<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Form\Validator;


class InArray extends \Demotic\Form\Validator
{

    /**
     * Constructor
     *
     * @param array $data
     * @param string $errorMessage
     * @throws \Demotic\Exception
     */
    public function __construct($data, $errorMessage = null)
    {
        if (!is_array($data)) {
            throw new \Demotic\Exception('InArray validator expect array of strings');
        }
        parent::__construct($data, $errorMessage);
    }

    /**
     * Get error
     *
     * @param array $values
     * @param int $valueKey
     * @param $environment
     * @return string|bool
     */
    public function getError($values, $valueKey, $environment)
    {
        if (empty($values[$valueKey])) {
            return false;
        }

        if (!in_array($values[$valueKey], $this->data)) {
            if ($this->errorMessage) {
                return $this->errorMessage;
            }
            if ($environment == \Demotic\Form::ENVIRONMENT_ADMIN) {
                $errorText = __('The value has to be one of:', 'Demotic-admin');
            } else {
                $errorText = __('The value has to be one of:', 'Demotic');
            }
            $errorText .= ' ' . implode(', ', $this->data);

            return $errorText;
        }

        return false;
    }

}
