<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Form\Validator;

use Demotic\Form\Validator;


/**
 * Antispam field validator
 */
class Antispam extends Validator
{

    /**
     * Get error
     *
     * @param array $values
     * @param int $valueKey
     * @param $environment
     * @return string|bool
     */
    public function getError($values, $valueKey, $environment)
    {
        if ($environment == \Demotic\Form::ENVIRONMENT_ADMIN) {
            $errorText = __('Form security check has failed. Please refresh the page.', 'Demotic-admin');
        } else {
            $errorText = __('Form security check has failed. Please refresh the page.', 'Demotic');
        }

        if (empty($values[$valueKey])) {
            return $errorText;
        }
        $value = $values[$valueKey];

        if (!is_array($value) || count($value) != 2) {
            return $errorText;
        }

        // First value should stay empty. Or its a bot :O)
        if (!isset($value[0]) || $value[0] != '') {
            return $errorText;
        }

        // Second value should be encoded today or yesterday date. Yesterday date is needed if user started to fill in data at 23:59
        if (!isset($value[1]) || ($value[1] != md5(date('Y-m-d') . ipConfig()->get('sessionName')) && $value[1] != date(
                    'Y-m-d',
                    time() - 24 * 60 * 60
                ))
        ) {
            return $errorText;
        }

        return false;
    }

}
