<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Form;


/**
 * Form fields and administration grid data validation
 */
abstract class Validator
{

    protected $data;
    protected $errorMessage;

    /**
     * All validators has to have the same constructor to make it easier to use them
     *
     * Thanks to this rule, you can add new validator to the form field without actually creating validator object, but just passing
     * validator class and data for the constructor. Eg. $field->addValidator('validatorClass', $validationData);
     * @param array $data additional parameters to tune up the validator. Like regular expression for Regex validator.
     * @param string $errorMessage Override default error message.
     */
    public function __construct($data = array(), $errorMessage = null)
    {
        $this->data = $data;
        $this->errorMessage = $errorMessage;
    }

    /**
     *
     * Return false on success or string on error
     *
     * Add extra params at the end if you need.
     * @param array $values all submitted data
     * @param string $valueKey key of value to be validated
     * @param string $environment \Demotic\Form::ENVIRONMENT_ADMIN or \Demotic\Fomr::ENVIRONEMNT_PUBLIC
     */
    public abstract function getError($values, $valueKey, $environment);

    /**
     * jQuery tools compatible validation arguments
     *
     * @return string
     */
    public function validatorAttributes()
    {
        return '';
    }

}
