<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Form\Field;

use Demotic\Form\Field;


class Submit extends Field
{

    /**
     * Render field
     *
     * @param string $doctype
     * @param $environment
     * @return string
     */
    public function render($doctype, $environment) : string
    {
        if(!empty($this->getName())){
            return '<button ' . $this->getAttributesStr($doctype) . ' class="btn btn-default ' . implode(
                ' ',
                $this->getClasses()
            ) . '" name="' . htmlspecialchars($this->getName()) . '" ' . $this->getValidationAttributesStr(
                $doctype
            ) . ' type="submit">' . htmlspecialchars($this->getValue()) . '</button>';
        }elseif(!empty($this->getValue())){
            return '<button ' . $this->getAttributesStr($doctype) . ' class="btn btn-default ' . implode(
                ' ',
                $this->getClasses()
            ) . '" name="" ' . $this->getValidationAttributesStr(
                $doctype
            ) . ' type="submit">' . htmlspecialchars($this->getValue()) . '</button>';
        }elseif(!empty($this->getName()) && !empty($this->getValue())){
            return '<button ' . $this->getAttributesStr($doctype) . ' class="btn btn-default ' . implode(
                ' ',
                $this->getClasses()
            ) . '" name="' . htmlspecialchars($this->getName()) . '" ' . $this->getValidationAttributesStr(
                $doctype
            ) . ' type="submit">' . htmlspecialchars($this->getValue()) . '</button>';
        }else{
            return '';
        }
    }



    /**
     * Get type
     *
     * @return string
     */
    public function getType() : string
    {
        return self::TYPE_SYSTEM;
    }

}
