<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Form\Field;


class RichTextLang extends \Demotic\Form\FieldLang
{

    /**
     * Render field
     *
     * @param string $doctype
     * @param $environment
     * @return string
     */
    public function render($doctype, $environment)
    {
        $languages = ipContent()->getLanguages();
        $answer = '';
        foreach ($languages as $language) {
            $langValue = '';
            $fieldValue = $this->getValue();
            if (is_array($fieldValue)) {
                if (!empty($fieldValue[$language->getCode()])) {
                    $langValue = $fieldValue[$language->getCode()];
                }
            }
            if (!is_string($langValue)) {
                //just in case we have an array or something else incompatible with below code in the database
                $langValue = '';
            }

            $answer .= '
<div class="input-group">
  <span class="input-group-addon">' . esc($language->getAbbreviation()) . '</span>

<textarea ' . $this->getAttributesStr($doctype) . ' class="form-control ' . implode(
                    ' ',
                    $this->getClasses()
                ) . '" name="' . escattr($this->getName()) . '[' . $language->getCode() . ']" ' . $this->getValidationAttributesStr(
                    $doctype
                ) . ' >' . escTextarea($langValue) . '</textarea>


</div>
            ';
        }
        return $answer;
        /*return '<textarea ' . $this->getAttributesStr($doctype) . ' class="form-control ' . implode(
            ' ',
            $this->getClasses()
        ) . '" name="' . esc($this->getName(), 'attr') . '" ' . $this->getValidationAttributesStr(
            $doctype
        ) . ' >' . esc($this->getValue(), 'textarea') . '</textarea>';*/
    }

}
