<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Form\Field;

use Demotic\Form\Field;


class HiddenSubmit extends Field
{

    /**
     * Render field
     *
     * @param string $doctype
     * @param $environment
     * @return string
     */
    public function render($doctype, $environment) : mixed
    {
        // Element should be available for browsers but we remove it from the regular flow.
        if(!empty($this->getName()) && !empty($this->getValue())){
            return '<input type="submit" style="position:absolute; left:-999999px; width:1px; height:1px; visibility:hidden;" tabindex="-1" ' . $this->getAttributesStr(
                $doctype
            ) . ' class="' . implode(' ', $this->getClasses()) . '" name="' . htmlspecialchars(
                $this->getName()
            ) . '" ' . $this->getValidationAttributesStr($doctype) . ' value="' . htmlspecialchars(
                $this->getValue()
            ) . '" />';
        }else{
            return null;
        }
    }

    /**
     * Get layout
     *
     * @return string
     */
    public function getLayout() : string
    {
        return self::LAYOUT_BLANK;
    }

}
