<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Form\Field;

use Demotic\Form\Field;


/**
 * Empty field. Common usage is to display global form error.
 * For example, for some reason the form could not be saved.
 * The error is not specific to any of the fields.
 * If your form could have such errors, you can put this empty
 * field at the top of your form and assign error message to it.
 * Then this error will appear above all fields as a global form error.
 */
class Blank extends Field
{

    /**
     * Render field
     *
     * @param string $doctype
     * @param $environment
     * @return string
     */
    public function render($doctype, $environment) : string
    {
        if(!empty($this->getValue())){
            return '<input ' . $this->getAttributesStr($doctype) . ' class="' . implode(
                ' ',
                $this->getClasses()
            ) . '" name="' . htmlspecialchars($this->getName()) . '"  ' . $this->getValidationAttributesStr(
                $doctype
            ) . ' type="hidden" value="' . htmlspecialchars($this->getValue()) . '" />';
        }else{
            return '<input ' . $this->getAttributesStr($doctype) . ' class="' . implode(
                ' ',
                $this->getClasses()
            ) . '" name="' . htmlspecialchars($this->getName()) . '"  ' . $this->getValidationAttributesStr(
                $doctype
            ) . ' type="hidden" value="" />';
        }
    }

}
