<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Exception;

/**
 * This exception does not extend Demotic\Exception!
 *
 * Purpose of this exception is to show error on the line database method was called.
 *
 * @package Demotic\Exception
 */
class Db extends \PDOException
{
    public $message;
    public $code;
    public $trace;
    public $previous;

    public function __construct($message = "", $code = 0, \PDOException $previous = null)
    {
        $this->message = $message;
        if ($previous) {
            $this->message = $previous->message;
            $this->code = $previous->code;
            $this->file = $previous->file;
            $this->line = $previous->line;
            $this->trace = $previous->getTrace();
            $this->previous = $previous;
        }

        $backtrace = debug_backtrace();

        // We need directory separator for Windows
        $ipDbPath = 'Demotic' . DIRECTORY_SEPARATOR . 'Db.php';
        $pathLength = strlen($ipDbPath);

        // We usually want exception to show error in the code that uses Db class
        foreach ($backtrace as $info) {
            if (substr($info['file'], -$pathLength) != $ipDbPath) {
                $this->file = $info['file'];
                $this->line = $info['line'];
                break;
            }
        }
    }
}
