<?php if( !empty( $data['pages']['pages'] ) ): ?>
    <?php foreach( $data['pages']['pages'] as $page ): ?>
        <div class="blog-post">
            <hr class="my-4">

            <h2>
                <?php if( !empty( $data['blog']['options']['titlelink'] ) ): ?>
                    <a href="<?php echo $page['urlPath']; ?>"><?php echo esc($page['title']); ?></a>
                <?php else: ?>
                    <?php echo esc($page['title']); ?>
                <?php endif; ?>
            </h2>
            <div class="blog-info-top">
                <?php if( !empty( $data['blog']['info']['date'] ) && $data['blog']['info']['date'] == 1 ): ?>
                    <?php echo date( ipGetOption( 'Blog.dateFormat' ), strtotime( $page['createdAt'] ) ); ?>
                <?php endif; ?>
                <?php if( !empty( $data['blog']['info']['category'] ) && $data['blog']['info']['category'] == 1 && !empty( $data['pages']['categories'][$page['parentId']]['title'] ) ): ?>
                    <?php echo esc( $data['pages']['categories'][$page['parentId']]['title'] ); ?>
                <?php endif; ?>
            </div>
            <div class="blog-intro">
                <?php if( !empty( $page['image']['imageOriginal'] ) && !empty( $data['blog']['image']['enable'] ) ): ?>
                    <div class="blog-image">
                        <?php echo '<img src="' . ipFileUrl( ipReflection( $page['image']['imageOriginal'], $imageOptions ) ) . '" alt="'.$page['title'].'" class="ipsImage" />'; ?>
                    </div>
                <?php endif; ?>
                <?php echo $page['intro']; ?>
            </div>
            <div class="blog-info-bottom">
                <?php if( !empty( $data['blog']['info']['date'] ) && $data['blog']['info']['date'] == 2 ): ?>
                    <?php echo date( ipGetOption( 'Blog.dateFormat' ), strtotime( $page['createdAt'] ) ); ?>
                <?php endif; ?>
                <?php if( !empty( $data['blog']['info']['category'] ) && $data['blog']['info']['category'] == 2 && !empty( $data['pages']['categories'][$page['parentId']]['title'] ) ): ?>
                    <?php echo $data['pages']['categories'][$page['parentId']]['title']; ?>
                <?php endif; ?>
            </div>
            <?php if( !empty( $data['blog']['options']['readmore'] ) ): ?>
                <div class="blog-read-more"><a href="<?php echo $page['urlPath']; ?>"><?php echo __( 'Read more', 'hcmsBlog' ); ?></a></div>
            <?php endif; ?>
            
        </div>
    <?php endforeach; ?>
    <?php if( !empty( $data['blog']['pagination']['type'] ) ): ?>
        <?php echo ipView('view/pagination.php', array_merge( $data['pages']['pagination'], $data['blog']['pagination'] ) )->render(); ?>
    <?php endif; ?>
<?php elseif( ipIsManagementState() ): ?>
    <div class="blog-post-empty">
        <?php echo __( 'Selected pages source is empty. Select other pages source or add new pages in', 'hcmsBlog' ); ?> <span class="blog-bold"><?php echo ipContent()->getPage($sourcePageId)->getTitle(); ?></span>.
        <?php if( !empty( $data['blog']['parent'] ) ): ?>
            <br /><?php echo __( 'Remember that parent pages acts like category.', 'hcmsBlog' ); ?>
        <?php endif; ?>
        <div class="blog-end">(<?php echo __( 'This note visible in managment state only', 'hcmsBlog' ); ?>)</div>
    </div>
<?php endif; ?>