<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

namespace Plugin\Blog\Widget\BlogList;

use Plugin\Blog\Widget\BlogList\Model;

class Controller extends \Demotic\WidgetController
{
    public function getTitle() {
        return __('Blog Posts List', 'Blog', false);
    }

    public function generateHtml( $revisionId, $widgetId, $data, $skin )
    {
        if( empty( $data['serialized'] ) ) {
            $data['serialized'] = '';
        } else {
            parse_str( $data['serialized'], $data );
            $data['currentLink'] = $revisionId;
        }
        if( empty( $data['data']['blog']['place'] ) ) {
            if( !empty( $revisionId ) ) {
                $revision = \Demotic\Gebtu\Revision::getRevision( $revisionId );
                $pageId = $revision['pageId'];
            } else {
                $pageId = $data['data']['blog']['pageId'];
            }
        } else {
            $pageId = $data['data']['blog']['place'];
        }
        $data['sourcePageId'] = $pageId;

        //pagination
        if( !empty( $data['data']['blog']['pagination']['limit'] ) ) {
            $limit = $data['data']['blog']['pagination']['limit'];
        } else {
            $limit = 10;
        }
        if( !$page = ipRequest()->getQuery('page') ) {
            $page = 1;
        }
        
        if( !empty( $data['data']['blog']['parent'] ) ) {
            $parentCat = true;
        } else {
            $parentCat = false;
        }
        if( !empty( $data['data']['blog']['image']['enable'] ) ) {
            if($data['data']['blog']['image']['width'] > 0 && $data['data']['blog']['image']['height'] > 0){
                $data['imageOptions'] = array(
                    'type' => 'center',
                    'width' => $data['data']['blog']['image']['width'],
                    'height' => $data['data']['blog']['image']['height'],   
                    'quality' => 80,
                    'forced' => false
                );
            }else{
                $data['imageOptions'] = array(
                    'type' => 'copy',
                );
            }
        }

        if( !empty( $data['data']['blog']['options'] ) ) {
            $options = $data['data']['blog']['options'];
        } else {
            
            $options = array(
                'introlimit' => ipGetOption( 'Blog.introLimit' ),
                'allowedtags' => ipGetOption( 'Blog.allowedTags' ),
                'blockname' => ipGetOption( 'Blog.blockName' )
            );
        }
        
        $data['data']['pages'] = Model::getPages( $pageId, $parentCat, array( 'limit' => $limit, 'page' => $page ), $options );
        
        return parent::generateHtml( $revisionId, $widgetId, $data, $skin );
    }

    public function adminHtmlSnippet()
    {
        $form = new \Demotic\Form();

        $yesNo = array(
            array( 0, __( 'No', 'Blog' ) ),
            array( 1, __( 'Yes', 'Blog' ) ),
        );
        
        $default[] = array( 0, __( 'Select Blog Category', 'Blog' ) );
        $results = array_merge( $default, Model::getPagesList() );
        
        $form->addField(new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'data[blog][pageId]',
                'value' => ipContent()->getCurrentPage()->getId()
            )
        ));
        
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][place]',
                'label' => __( 'Blog posts source', 'Blog' ),
                'values' => $results
            )
        ));
        
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][parent]',
                'label' => __( 'Make parent page act like post category', 'Blog' ),
                'values' => $yesNo,
                'note' => __( 'One level depth only', 'Blog' ) 
            )
        ));
        
        $form->addFieldset(new \Demotic\Form\Fieldset(__( 'Pagination', 'Blog' )));
        
        $paginationTypes = array(
            array( 3, __( 'Show pagination', 'Blog' ) ),
            array( 1, __( 'Show page numbers only', 'Blog' ) ),
            array( 2, __( 'Show Prev/Next links only', 'Blog' ) ),
            array( 0, __( 'Do not show pagination', 'Blog' ) ),
        );
        
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][pagination][type]',
                'label' => __( 'Type', 'Blog' ),
                'values' => $paginationTypes,
            )
        ));
        
        $form->addField(new \Demotic\Form\Field\Text(
            array(
                'name' => 'data[blog][pagination][limit]',
                'label' => __( 'Post limit per page', 'Blog' ),
                'value' => ipGetOption( 'Blog.postLimit' )
            )
        ));
        
        $form->addFieldset(new \Demotic\Form\Fieldset(__( 'Options', 'Blog' )));
        $orderTypes = array(
            array( 0, __( 'By date DESC', 'Blog' ) ),
            array( 1, __( 'By date ASC', 'Blog' ) ),
            array( 2, __( 'By page position DESC', 'Blog' ) ),
            array( 3, __( 'By page position ASC', 'Blog' ) ),
        );
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][options][order]',
                'label' => __( 'Order by', 'Blog' ),
                'values' => $orderTypes,
            )
        ));
        $form->addField(new \Demotic\Form\Field\Text(
            array(
                'name' => 'data[blog][options][introlimit]',
                'label' => __( 'Intro limit (if seperator is not placed)', 'Blog' ),
                'value' => ipGetOption( 'Blog.introLimit' )
            )
        ));
        $form->addField(new \Demotic\Form\Field\Text(
            array(
                'name' => 'data[blog][options][allowedtags]',
                'label' => __( 'Allowed tags', 'Blog' ),
                'note' => 'All others will be stripped',
                'value' => ipGetOption( 'Blog.allowedTags' )
            )
        ));
        
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][options][readmore]',
                'label' => __( 'Show read more link?', 'Blog' ),
                'values' => $yesNo,
                'value' => ipGetOption( 'Blog.showReadMore' ) == 'Yes' ? 1 : 0
            )
        ));
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][options][titlelink]',
                'label' => __( 'Show title as link to post?', 'Blog' ),
                'values' => $yesNo,
                'value' => ipGetOption( 'Blog.addTitlelink' ) == 'Yes' ? 1 : 0
            )
        ));
        $form->addField(new \Demotic\Form\Field\Text(
            array(
                'name' => 'data[blog][options][blockname]',
                'label' => __( 'Post block name', 'Blog' ),
                'value' => ipGetOption( 'Blog.blockName' ),
                'note' => __( 'Separate blocks with comma, block name order is sensitive.', 'Blog' )
            )
        ));
        
        $yesNoUpBot = array(
            array( 0, __( 'No', 'Blog' ) ),
            array( 1, __( 'Yes, top', 'Blog' ) ),
            array( 2, __( 'Yes, bottom', 'Blog' ) ),
        );
        $form->addFieldset(new \Demotic\Form\Fieldset(__( 'Additional Blog Options', 'Blog' )));
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][info][date]',
                'label' => __( 'Show post date', 'Blog' ),
                'values' => $yesNoUpBot,
                'value' => ipGetOption( 'Blog.showDate' ) == 'Yes' ? 1 : 0
            )
        ));
        //This functionality will be added later
        // $form->addField(new \Demotic\Form\Field\Select(
        //     array(
        //         'name' => 'data[blog][info][time]',
        //         'label' => __( 'Show post time', 'Blog' ),
        //         'values' => $yesNoUpBot,
        //         'value' => ipGetOption( 'Blog.showTime' ) == 'Yes' ? 1 : 0
        //     )
        // ));
        //This functionality will be added later
        // $form->addField(new \Demotic\Form\Field\Select(
        //     array(
        //         'name' => 'data[blog][info][author]',
        //         'label' => __( 'Show author name', 'Blog' ),
        //         'values' => $yesNoUpBot,
        //     )
        // ));
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][info][category]',
                'label' => __( 'Show category name', 'Blog' ),
                'values' => $yesNoUpBot,
            )
        ));
        
        $form->addFieldset(new \Demotic\Form\Fieldset(__( 'Image Options', 'Blog' )));
        $form->addField(new \Demotic\Form\Field\Select(
            array(
                'name' => 'data[blog][image][enable]',
                'label' => __( 'Enable image', 'Blog' ),
                'values' => $yesNo,
                'note' => __( 'First image of post will be displayed', 'Blog' ) 
            )
        ));
        
        $form->addField(new \Demotic\Form\Field\Text(
            array(
                'name' => 'data[blog][image][width]',
                'label' => __( 'Image width (Input 0 to show full image)', 'Blog' ),
                'value' => ipGetOption( 'Blog.imageWidth' )
            )
        ));
        
        $form->addField(new \Demotic\Form\Field\Text(
            array(
                'name' => 'data[blog][image][height]',
                'label' => __( 'Image height (Input 0 to show full image)', 'Blog' ),
                'value' => ipGetOption( 'Blog.imageHeight' )
            )
        ));
        
        return ipView('snippet/edit.php', array( 'form' => $form ))->render();
    }
}
